# 2.1.1

- add floatval to the models

# 2.1.0

## Added:

- WebhookPayload to handle tabby webhook payload as object

# 2.0.4

- Add V1 and V2

# 2.0.3

- Fix null arrays

# 2.0.2

- Fix `static const` bug.

# 2.0.1

**Added:**

- `getRejectionReason()` method in `CheckoutSession` to return a detailed rejection reason based on the session's configuration.
- `isRejected()` method to check if the session's status is "rejected".
- Integrated rejection reason constants from `Tabby\Constants` for rejection messages.

**Changed:**

- Modified `getPaymentUrl()` to provide more context in error messages, including rejection reasons when the session is rejected.

## 2.0.0

### Added

- **Checkout**
  - Create a session
  - Retrieve an existing checkout session
- **Payment**
  - Update a payment
  - Capture a payment
  - Refund a payment
  - Close a payment
  - List of all payments
- **Webhooks**
  - Register a webhook
  - Retrieve all webhooks
  - Retrieve a webhook
  - Update a webhook
  - Delete a webhook

## 1.0.5

- **Refactored `createSession` method**: Split `createSession` logic to return the complete response instead of only the `web_url`.
- **New `getPaymentUrl` method**: Extracted `web_url` retrieval into a dedicated `getPaymentUrl` method, handling errors if `web_url` is missing or the session is rejected.
- **Improved error handling**: Enhanced exception messages for missing payment IDs, rejected sessions, and missing `web_url` in responses.
- **Code cleanup**: Minor code refactoring for readability and modularity across the service methods.

## 1.0.4

- Enhanced Error Handling: Resolved warning errors generated by Tabby, improving overall stability and user experience.

## 1.0.3

- Changed `dob` to optional input

## 1.0.2

- Formatting of Numeric Values to Strings.

## 1.0.1

- **Breaking Changes**
  - Removed `TabbyBuyerHistory` and `TabbyOrderHistory` as required parameters in `createSession`. These are now optional and are initialized with default values if not provided.
- **Enhancements**

  - Added `description` parameter to `createSession` for improved session details.
  - Simplified code in `ExampleController` for quicker integration.
  - Updated `createSession` method to initialize `TabbyBuyerHistory` and `TabbyOrderHistory` with default values if omitted, allowing more flexible usage.
  - Refactored request error handling to provide specific error messages and codes, improving debugging support.

- **Documentation**
  - Updated `README` with revised example code reflecting changes in required parameters for `createSession`.
  - Simplified the example for initializing `TabbyService` by using placeholders for credentials.

## 1.0.0

- Released the initial version of Tabby Package with essential features.
